#' Read INSEE data compressed in tar files
#' 
#' @param path where to find the data
#' @return Nothing
#' 
#' @keywords internal

update_esane_from_tar = function(path) {
	
	path_archive = file.path(path, "archive")
	path_tmp = file.path(path, "tmp")
	path_output = file.path(path, "raw")
	
	dir.create(path_output, FALSE, TRUE)
	dir.create(path_tmp, FALSE, TRUE)
	file_tmp = file.path(path_tmp, "tmp.txt")
	
	for (f in dir(path_archive)) {
		year = strsplit(f, "[_.]")[[1]][2] # f supposed to be ESANE_XXXX.tar.gz
		file_archive = file.path(path_archive, f)
		file_esane = file.path(path_tmp, gsub(".tar.gz", ".txt", f))
		
		message("Processing ", file_archive, "\n")
		
		utils::untar(file_archive, exdir = path_tmp)
			
		esane = utils::read.table(file_esane, comment.char ="", 
			stringsAsFactors=FALSE)[[1]]

		### Transformation of format to be a good csv file
		for (n in c("N0", "N1", "N2", "N3", "N5")) {
			message("\t... level ", n, "\n")

			pattern = paste("#", year, "#", n, "#", sep="")
			sel = grep(pattern, esane)
			if (length(sel) == 0) next
			tmp = esane[sel]
			
			pattern = "#19#009#|#19#119#|#19#224#|#19#250#" # Not interested in ventilation by workforce
			sel = grep(pattern, tmp)
			if (length(sel) > 0) tmp = tmp[-sel]
			
			tmp = gsub("#", ";", tmp) # Transform # in ;
			tmp = gsub(";+$", "", tmp) # Remove ; at the end of each line
			tmp = gsub(";{8}", ";", tmp) # Remove 8 ; (when no factor)
			tmp = gsub(";+ND$|;+SE$|;+SR$", ";;NA", tmp) # Deal with empty data
			write(tmp, file_tmp)
			tmp = utils::read.table(file_tmp, header=FALSE, dec=".", sep=";",
				colClasses=c("NULL", "character", "integer", "NULL", 
				"character", "integer", "numeric"))
			names(tmp) = c("VARIABLE", "YEAR", "ACTIVITY", "FACTOR", 
				"VALUE")
			tmp[["FACTOR"]][is.na(tmp[["FACTOR"]])] = 0
			tmp[["VALUE"]] = tmp[["VALUE"]] * 10 ^ tmp[["FACTOR"]]
			tmp = tmp[c("YEAR", "ACTIVITY", "VARIABLE", "VALUE")]
			 
			utils::write.csv2(tmp, file.path(path_output, 
				paste("esane-", year, "-", n, ".csv", sep="")), 
				row.names=FALSE)
			rm(tmp)
		}
	}
	
	unlink(path_tmp, TRUE)
}
