#' Read INSEE data as generated by update_esane_from_tar
#' 
#' @param path character, where to find the data
#' @param what vector of character, fields that are kept
#' @return Nothing
#' 
#' @keywords internal

update_esane_from_csv = function(path, what = 
	c("ACTENTNOMESS", "ACTCATVALESE", "EMPSALNOMESS", "ESEQTPNOMESS", "BAC123VALESE", "BAC124VALESE",
		"BACSTOMPPESE", "BAC151VALESE", "BAC152VALESE", "BAC153VALESE", "BAC155VALESE", "BAC156VALESE")) {	
	# ACTENTNOMESS = NA, # Nombre d'entreprises
	# ACTCATVALESE = NA, # Chiffre d'affaire HT
	# EMPSALNOMESS = NA, # Effectif salarié au 31/12
	# ESEQTPNOMESS = NA, # Effectif salarié en équivalent temps plein
	# BAC123VALESE = NA, # Matériel (gros matériel spécifique)
	# BAC124VALESE = NA, # Matériel (le reste moins spécifique, y compris matériel de trabnsport)
	# BACSTOMPPESE = NA, # Stock (ensemble ?)
	# BAC151VALESE = NA, # Stock (matières premières)	
	# BAC152VALESE = NA, # Stock (matières premières aussi...)	
	# BAC153VALESE = NA, # Stock (en cours de production de biens)	
	# BAC155VALESE = NA, # Stock (produits intermédaires et finis)
	# BAC156VALESE = NA  # Stock (marchandises)	
	
	path_input = file.path(path, "raw")
	path_output = file.path(path, "net")

	dir.create(path_output, FALSE, TRUE)
	
	# Create csv files one for each year and each level with fields specified in what	
	for (f in dir(path_input)) {
		esane = utils::read.csv2(file.path(path_input, f), 
			colClasses=c("integer", "factor", "factor", "numeric"))

		result = data.frame(ACTIVITY = levels(esane[["ACTIVITY"]]))
		rownames(result) = result[["ACTIVITY"]]
		
		for (variable in what) {
			result[[variable]] = NA
			result[as.character(esane[esane[["VARIABLE"]] == variable, "ACTIVITY"]), variable] = esane[esane[["VARIABLE"]] == variable, "VALUE"]
		}			
		utils::write.csv2(result, file.path(path_output, f), row.names = FALSE)
	}	
}
