#' Summarize model damaging function
#' 
#' @param model object of class model
#' @return a data.frame of damages summed by action, with NA only where no numeric value is available
#' 
#' @keywords internal

summarize_model_damaging = function(model)
{
	result = data.frame(
		h = rep(as.numeric(dimnames(model[["damaging"]][["absolute"]][["building"]])[["h"]]), times = length(dimnames(model[["damaging"]][["absolute"]][["building"]])[["d"]])),
		d = rep(as.numeric(dimnames(model[["damaging"]][["absolute"]][["building"]])[["d"]]), each = length(dimnames(model[["damaging"]][["absolute"]][["building"]])[["h"]]))
	)
		
	for (dam in c("absolute", "relative")) {
		for (what in levels(floodam.building::COMPONENT_ELEMENTARY[[model[["category"]][1]]])) {
			result[[paste(dam, what, sep = "_")]] = as.vector(model[["damaging"]][[dam]][[what]])
		}
	}
	result[["surface_building"]] = as.vector(model[["damaging"]][["surface"]][["building"]])
	
	result
}
