#' Summarize elementary damaging function
#' 
#' @param damaging array of elementary damaging, detailed by action
#' @return a data.frame of damages summed by action, with NA only where no numeric value is available
#' 
#' @keywords internal

summarize_elementary_damaging = function(damaging)
{
	damage = as.vector(apply(damaging, 1:2, sum, na.rm = TRUE))
	damage[apply(damaging, 1:2, function(y) { all(is.na(y)) })] = NA

	data.frame(
		h = rep(as.numeric(dimnames(damaging)[["h"]]), times = length(dimnames(damaging)[["d"]])),
		d = rep(as.numeric(dimnames(damaging)[["d"]]), each = length(dimnames(damaging)[["h"]])),
		damage = damage)
}
