#' split a data.frame with some preliminary operations
#' 
#' @param x, data.frame to split, can be NULL.
#' @param what, column that will be used for splitting
#' @param level, vector of characters that will be used to reorganize `x[[what]]`
#' 
#' @keywords internal

split_special = function(x, what, level) {
	if (is.null(x)) {
		return(
			stats::setNames(
				lapply(level, function(x){NULL}),
				level
			)
		)
	}
	x[[what]] = factor(as.character(x[[what]]), levels = level)
	split(x, x[[what]])
}

