#' Show useful information of model.
#' 
#' @param model model
#' @return NULL
#' @examples
#' 
#' 	model_path = list(
#' 		data = system.file("extdata", package = "floodam.building"),
#' 		output = tempdir()
#' 	)
#' 	model = analyse_model(
#' 		model = "adu_t", 
#' 		type = "adu", 
#' 		stage = c("load", "extract", "damaging"), 
#' 		path = model_path
#' 	)
#' 	show_log(model)
#' 
#' @export


show_log = function(model) {
	
	file_log = file.path(model[["path"]][["model_log"]], model[["file_name"]][["log"]])

	info = scan(file_log, what = character(), sep = "\n")
	info = paste(info, collapse = "\n")
	cat(info, "\n")
	
	invisible(NULL)
}
