#' Produce an elementary function damage, save it make a graph if asked.
#' 
#' @param component_elementary data.frame of possible component_elementary
#' @param category_vulnerability data.frame of damaging tables
#' @param component_elementary_action data.frame of damaging actions
#' @param category_vulnerability_complex data.frame of damaging tables complex
#' @param hazard_range a list of value where to calculate damaging functions
#' @param d_select selected values of durations where to make some focus. At list one value.
#' @param path path for saving the result. Default to NULL, nothing is saved
#' @param graph boolean, should a graph be made
#' @param verbose logical
#' @return a list of array giving detailed damaging function
#' 
#' @keywords internal

produce_elementary_damaging = function(
		component_elementary,
		category_vulnerability, 
		category_vulnerability_complex,
		component_elementary_action, 
		hazard_range,
		d_select,
		path = NULL,
		graph = TRUE,
		verbose = TRUE
	)
{
	id = component_elementary[["component_elementary"]]
	if (verbose == TRUE) message(sprintf("\t- %s\n", id))
	
	# Selecting value
	damaging = category_vulnerability[category_vulnerability[["category_vulnerability"]] == component_elementary[["category_vulnerability"]], ]
	complex = category_vulnerability_complex[category_vulnerability_complex[["category_vulnerability"]] == component_elementary[["category_vulnerability"]], ]
	action = component_elementary_action[component_elementary_action[["component_elementary"]] == id, ]
	missing = damaging[["action"]][!damaging[["action"]] %in% action[["action"]]]
	if (length(missing) > 0) {
		action =  rbind(action, 
			component_elementary_action[
				component_elementary_action[["component_elementary"]] == component_elementary[["category_vulnerability"]] &
				component_elementary_action[["action"]] %in% missing, ]
		)
	}
	result = compose_elementary_damaging(component_elementary, damaging, complex, action, hazard_range)

	if (!is.null(path)) {
		utils::write.csv2(summarize_elementary_damaging(result), file.path(path[["damaging_output_csv"]], paste(id, "csv", sep=".")), row.names = FALSE)
		if (graph == TRUE)	{plot(result, name = id, d_select = d_select, output = path[["damaging_output_pdf"]])}
	}

	invisible(result)
}
