#' plot a model.
#'
#' @param x an object of class model
#' @param ... some extra parameters (unused)
#' @return Nothing
#'
#' @export

print_model = function(x, ...)
{
    result = format(x, ...)
    cat(result)
    invisible(result)

}

#' format a model.
#'
#' @param x an object of class model
#' @param ... extra parameters
#' @return Nothing
#'
#' @export

format_model = function(x, ...)
{
    file_log = file.path(x[["path"]][["model_log"]], x[["file_name"]][["log"]])

    report = c(
        "Object of class 'model'\n",
        sprintf("- name: '%s'\n", x[["name"]]),
        sprintf(
            "- %s room(s) in %s storey(s)\n",
            length(grep("room", x[["data_table"]][["room"]][["room"]])),
            length(grep("storey", x[["data_table"]][["storey"]][["storey"]]))
        ),
        sprintf(
            "- surface: \texternal = %s [m2]\tinternal = %s [m2]\tratio = %s\n",
            round(x[["value"]][["surface"]][["external"]], 2),
            round(x[["value"]][["surface"]][["internal"]], 2),
            round(x[["value"]][["surface"]][["ratio"]], 2)
        ),
        sprintf(
            "- value: \tbuilding = %s [euro]\tfurniture = %s [euro]\n",
            round(x[["value"]][["monetary"]][["building"]], 2),
            round(x[["value"]][["monetary"]][["furniture"]], 2)
        ),
        if (!is.null(x[["damaging"]])) "- damaging computed\n",
        sprintf(
            "- log information available at: %s\n",
            file.path(x[["path"]][["model_log"]], x[["file_name"]][["log"]])
        )
    )
    report
}