#' Print a readable version of list
#
#' @param l list
#' @param i indentation (for internal use, recursive)
#' @return a readable view of list
#' 
#' @keywords internal

print_list = function(l, i = 0) {
  if (!is.list(l)) return(paste(l, collapse = " / "))
  indent = paste("\n", paste(rep("\t", i), collapse = ""), sep = "")
  paste(indent, names(l), ": ", sapply(l, print_list, i = i + 1), sep = "", collapse = "")
}
