#' Create a trace of order chosen for walls
#' 
#' @param wall data.frame of walls characteristics, supposed to be well ordered by order_wall
#' @param id_letter vector of character, allowing to have the classification for wall designated by
#' letters
#' @return vector order of the order chosen
#' 
#' @keywords internal

order_wall = function(wall, id_letter = getOption("floodam_building_id_letter")) {
	# Manipulation to get the wall in the good order... To be changed !
    # Needs adaptation in building
	
	ID = sapply(strsplit(as.character(wall), "[_]"), `[[`, 2)
	result = rep(NA, length(ID))
	selection = !is.na(suppressWarnings(as.integer(ID)))
	result[selection] = as.integer(ID[selection])
	
	# Because some fucking walls are ordered by letters
	result[!selection] = match(ID[!selection], id_letter) # + max(result[selection])

	if (any(is.na(result)))
        warning("Hum. Something wrong with naming apparently in some wall!")

    return(result)
}

order_room = function(room) {
	room = as.character(room)
	result = rep(NA, length(room))

	external = grep("external", room)
	if (length(external) > 0) {
		result[external] = as.integer(
            sapply(strsplit(room[external], "[_]"), `[[`, 2)
        )
	}

	internal = grep("room", room)
	if (length(internal) > 0) {
		result[internal] = length(external) +
            as.integer(sapply(strsplit(room[internal], "[_]"), `[[`, 2))
	}

	if (any(is.na(result)))
        warning("Hum. Something wrong with naming apparently in some room!")
	return(result)
}
