#' Change the selection into a boolean vector depending on component
#' 
#' @param component the part of the model where a component will be replaced
#' @param selection the dimensioning height or the name of the rooms where measures will be applied
#' @param height the column of component containing special height information (ceiling)
#' @return selection as a boolean vector corresponding to the room in component
#' 
#' @keywords internal
  
make_selection = function(component, selection, height = NULL) {
if (is.numeric(selection) == TRUE) {
  if (is.null(height)) {
    ind_selection = which(component[["H_abs"]] <= selection, arr.ind = TRUE)
    selection = rep(FALSE, nrow(component))
    selection[ind_selection] = TRUE
  } else {
    ind_selection = which(component[["H_abs"]] + component[[height]] <= selection, arr.ind = TRUE)
    selection = rep(FALSE, nrow(component))
    selection[ind_selection] = TRUE
  }
  
}	else {
  if (selection[1] == "storey") {
    selection = selection[-1]
    selection = component[["storey"]][which(as.character(component[["storey"]][["name"]]) %in% selection, arr.ind = TRUE)]
    ind_selection = which(component[["storey"]] %in% selection, arr.ind = TRUE)
    selection = rep(FALSE, nrow(component))
    selection[ind_selection] = TRUE
  } else if (selection[1] == "all") {
    selection = rep(TRUE, nrow(component))
  } else {
    ind_selection = which(component[["room"]] %in% selection[-1], arr.ind = TRUE)
    selection = rep(FALSE, nrow(component))
    selection[ind_selection] = TRUE
  }
}
  
	
	return(selection)
}
  
  

