#' Extract information at room level
#' 
#' @param model_building a list that should represent a building version of model
#' @return a data.frame of informations extracted, ordered.
#' 
#' @keywords internal

extract_room_03 = function(model_building) {
	pattern = floodam.building::BUILDING[[model_building[["general"]][["version"]]]]
	pattern = pattern[["building"]][["storey"]][["generic"]]
	pattern = construct_data_frame_pattern(pattern)
	selection = grep("building", names(model_building), value = TRUE)

	result = simplify2data_frame(
		mapply(
			extract_something_from_building,
			model_building[selection],
			selection, 
			MoreArgs = list(
				pattern = pattern,
				what = "room"
			),
			SIMPLIFY = FALSE
		)
	)

	result = result[order(result[["building"]], result[["storey"]], order_room(result[["room"]])),]
}

extract_room_02 = function(building, pattern) {
	pattern = construct_data_frame_pattern(pattern)
	selection = grep("storey", names(building), value = TRUE)
	simplify2data_frame(
		mapply(
			extract_something_from_storey,
			building[selection],
			selection, 
			MoreArgs = list(pattern = pattern),
			SIMPLIFY = FALSE
		)
	)
}
