#' Extract information at storey level
#' 
#' @param model_building a list that should represent a building
#' @return a data.frame of informations extracted
#' 
#' @keywords internal

extract_protection_03 = function(model_building) {		
	pattern = construct_data_frame_pattern(floodam.building::BUILDING[[model_building[["general"]][["version"]]]][["building"]][["protection"]])
	selection = grep("building", names(model_building), value = TRUE)
	
	result = simplify2data_frame(mapply(extract_something_from_building, model_building[selection], selection, 
		MoreArgs = list(pattern = pattern, what = "protection"),
		SIMPLIFY = FALSE))

	result[order(result[["building"]], result[["protection"]]), ]
}

