#' Extract information of type parameter
#' 
#' @param element list
#' @param pattern the pattern that will be used to extract information
#' @return a data.frame of informations extracted
#' 
#' @keywords internal

extract_parameter_02 = function(element, pattern) {
	extract_by_parameter = function(item, pattern) {
		pattern = construct_data_frame_pattern(pattern[[3]])

		simplify2data_frame(
			mapply(extract_information, item, names(item), 
			MoreArgs = list(pattern = pattern, type_name = "type"), SIMPLIFY = FALSE))
	}
	
	parameter = names(pattern)[sapply(pattern, is.list)]
	result = mapply(
		extract_by_parameter,
		element[parameter],
		pattern[parameter],
		SIMPLIFY = FALSE
	)
	return(result[!sapply(result, is.null)])
}

extract_parameter_03 = function(model_building) {
	extract_by_parameter = function(item, pattern) {
		pattern = construct_data_frame_pattern(pattern[[3]])

		simplify2data_frame(
			mapply(extract_information, item, names(item), 
			MoreArgs = list(pattern = pattern, type_name = "type"), SIMPLIFY = FALSE))
	}

	element = model_building[["element"]]
	pattern = floodam.building::BUILDING[[model_building[["general"]][["version"]]]][["element"]]
	parameter = names(pattern)[sapply(pattern, is.list)]

	result = mapply(
		extract_by_parameter,
		element[parameter],
		pattern[parameter],
		SIMPLIFY = FALSE
	)
	return(result[!sapply(result, is.null)])
}

