#' Extract information at building level
#' 
#' @param model_building a list that should represent a building version of model
#' @return a data.frame of informations extracted
#' 
#' @keywords internal

extract_building_03 = function(model_building) {
	pattern = floodam.building::BUILDING
	pattern = pattern[[model_building[["general"]][["version"]]]][["building"]]
	pattern = construct_data_frame_pattern(pattern)
	selection = grep("building", names(model_building), value = TRUE)

	result = simplify2data_frame(mapply(extract_information, model_building[selection], selection, 
		MoreArgs = list(pattern = pattern, type_name = "building"),
		SIMPLIFY = FALSE))

	result[order(result[["building"]]), ]
}
