#' Create elementary components from damaging and test internal integrity
#' 
#' @param damaging_action data.frame of actions
#' @param damaging_value data.frame fo values
#' @param damaging_table data.frame fo damage tables
#' @param damaging_complex data.frame fo damage complex tables
#' @return a data.frame of all present component_elementary
#' 
#' @keywords internal

create_component = function(damaging_action, damaging_value, damaging_table, damaging_complex) {
	test_integrity = function(data, name = "", x = paste(name, "x", sep = "_"), y = paste(name, "y", sep = "_")) 
	# Test if columns resulting from the merge are consistent. Try to give some useful messages if not.
	{
		if (name == "") stop("Hum... Hard to check without no instructions...")

		data = apply(data[c(x, y)], 2, as.character)

		if (any(is.na(data[, x]) & is.na(data[, y]))) {
			msg = paste("Pb with", name, "- Step 1")
			stop(msg)
		}

		if (any(data[, x] != data[, y], na.rm = TRUE)) {
			msg = paste("Pb with", name, "- Step 2")
		}

		data[, x][is.na(data[, x])] = data[, y][is.na(data[, x])]

		return(data[, x])
	}
	
  result = merge(
    damaging_action[c("category", "component", "component_elementary")], 
    damaging_value[c("category", "component", "component_elementary")], 
    by = "component_elementary", all = TRUE
  )
  
  result[["component"]] = test_integrity(result, "component")
  result[["category"]] = test_integrity(result, "category")
  result[["component_elementary"]] = as.character(result[["component_elementary"]])
  result = result[result[["component_elementary"]] != "default", ]

  return(unique(result[c("component", "category", "component_elementary")]))
}

