#' Compose elementary damaging function
#' 
#' @param component_elementary data.frame of component_elementary values
#' @param damaging data.frame of damaging tables
#' @param action data.frame of damaging actions
#' @param complex data.frame of damaging complex information
#' @param hazard_range a list of value where to calculate damaging functions
#' @return an array of dimension 3 with dimension given by the number of actions and range of h and d
#' 
#' @keywords internal

compose_elementary_damaging = function(component_elementary, damaging, complex, action, hazard_range) {
	interpolate_complex = function(complex, h, d) {
		# interpolating p_action when this parameter is complex
		# selection of columns of type h_000
		# selection of value taken by p_action depending on the duration considered
		cols = grep("^h[_|_.]{1,2}[0-9]+$", names(complex), value = TRUE)
		x = as.numeric(gsub("h[_]", "", gsub("[.]", "-", cols)))
		y = lapply(as.numeric(d), 
			function(x){complex[which(x > complex[["d_min"]] & x <= complex[["d_max"]]), cols]})	
		fun_temp = function(y, x, h){
			if (nrow(y) == 0) {
				# dealing with the eventuality that some durations are out of range
				rep(NA, length(h))
			} else {
				stats::approx(x, y = y, xout = as.numeric(h), rule = 1:2)[["y"]]
			}
		}
		mapply(fun_temp, y = y, MoreArgs = list(x = x, h = h))
	}
	
	l_action = unique(as.character(damaging[["action"]]))
  result = array(as.numeric(NA),
                  dim = c(length(hazard_range[[1]]), length(hazard_range[[2]]), length(l_action)),
                  dimnames = c(hazard_range, list(action = l_action)))
	class(result) = "elementary_damaging"
	# 3 next lines need some adjustment because should consider l_action instead of damaging[["action"]]
	attr(result, "h_action") = stats::setNames(
		damaging[["h_action"]],
		damaging[["action"]]
	)
	attr(result, "dilapidation") = stats::setNames(
		damaging[["dilapidation"]],
		damaging[["action"]]
	)
	attr(result, "support") = stats::setNames(
		rep(NA, length(damaging[["action"]])),
		damaging[["action"]]
	)
	attr(result, "value") = stats::setNames(
		rep("action", length(damaging[["action"]])),
		damaging[["action"]]
	)
	attr(result, "v") = unlist(component_elementary[c("v_min", "v_max")])
	attr(result, "component_elementary") = unique(component_elementary[["component_elementary"]])

  for (r in seq(nrow(damaging)))
  {
    dam = damaging[r, ]
    a = as.character(dam[, "action"])

		v = unlist(action[action[["action"]] == a, c("v_min", "v_max")])
		attr(result, "support")[a] = action[action[["action"]] == a, "v_support"]
		if (action[action[["action"]] == a, "value"] == TRUE) {
			attr(result, "support")[a] = component_elementary[["v_support"]]
			attr(result, "value")[a] = "value"
			v = unlist(component_elementary[c("v_min", "v_max")])
#~ 			if (is.na(attr(result, "support")[a])) {
#~ 				attr(result, "support")[a] = component_elementary[["v_support"]]
#~ 			} else if (attr(result, "support")[a] != component_elementary[["v_support"]]) {
#~ 				stop(sprintf("Compatibility problem of support for action %s in component_elementary %s", a, component_elementary[["component_elementary"]]))
#~ 			}
#~ 			if (!all(is.na(unlist(component_elementary[c("v_min", "v_max")])) & is.na(v))) {
#~ 				v = mapply(sum, v, unlist(component_elementary[c("v_min", "v_max")]), na.rm = TRUE)
#~ 			}
 		}  
    
    h = as.character(in_range(hazard_range[["h"]], dam[, c("h_min", "h_max")]))
    d = as.character(in_range(hazard_range[["d"]], dam[, c("d_min", "d_max")]))
    
    i = switch(as.character(dam[, "i_action"]),
			"complex" = interpolate_complex(complex[complex[["action"]] == dam[, "action"] & complex[["type"]] == "i_action", ], h, d),
      csv2num(dam[, "i_action"]))
    
    p = switch(as.character(dam[, "p_action"]),
			"complex" = interpolate_complex(complex[complex[["action"]] == dam[, "action"] & complex[["type"]] == "p_action", ], h, d),
			csv2num(dam[, "p_action"]))
			
    result[h, d, a] = p * i * mean(v)
  }
  
  
  return(result)
}

