#' For a selection by room, complete the substitution of the second part of the openings
#' 
#' @param x the building information list of the model to be adapted
#' @param correspondence the list of correspondence tables with the origin and final elements
#' @return the new building list
#' 
#' @keywords internal

complete_substitution = function(x, correspondence) 
{ 

  building = x[["building"]]
  sub_coords = data.frame(x = NA, y = NA)
  
  #Spot the coordinates of the new elements
  for (st in names(building)){
    all_room = c(grep("external", names(building[[st]]), value = TRUE), grep("room", names(building[[st]]), value = TRUE))
    for (ro in all_room){
      for (wa in grep("^wall", names(building[[st]][[ro]]), value = TRUE)){
        for (op in grep("^opening", names(building[[st]][[ro]][[wa]]))){
          if (building[[st]][[ro]][[wa]][[op]][["type"]] %in% correspondence[["final"]]){
            sub_coords = rbind(sub_coords, building[[st]][[ro]][[wa]][[op]][["coordinates"]])
          }
        }
      }
    }
  }
  
  #Substitute the "twin" part of opening
  for (st in names(building)){
    all_room = c(grep("external", names(building[[st]]), value = TRUE), grep("room", names(building[[st]]), value = TRUE))
    for (ro in all_room){
      for (wa in grep("^wall", names(building[[st]][[ro]]), value = TRUE)){
        for (op in grep("^opening", names(building[[st]][[ro]][[wa]]))){
          if (building[[st]][[ro]][[wa]][[op]][["coordinates"]][1] %in% sub_coords[["x"]]){
            if (building[[st]][[ro]][[wa]][[op]][["coordinates"]][2] %in% sub_coords[sub_coords[["x"]] == building[[st]][[ro]][[wa]][[op]][["coordinates"]][1], "y"]
               & building[[st]][[ro]][[wa]][[op]][["type"]] %in% correspondence[["origin"]]){
              building[[st]][[ro]][[wa]][[op]][["type"]] = correspondence[correspondence[["origin"]] == building[[st]][[ro]][[wa]][[op]][["type"]], "final"]
            }
          }
        }
      }
    }
  }
  

  return(building)
  
}

