#' @keywords internal

check_damaging_table = function(f_name, correct = FALSE){
  check = function(f, n){any(utils::read.csv2(f)[["curve"]] != n)}
  
  for (type in dir(getOption("floodam_building_path")[["damaging"]])){
    files = grep("csv$", file.path(getOption("floodam_building_path")[["damaging"]], type, dir(file.path(getOption("floodam_building_path")[["damaging"]], type))), value = TRUE)
    problem = files[sapply(files, check, type)]
    if (length(problem) > 0) {
      write(paste("Files with trouble in", type), f_name, append=TRUE)
      write(paste("\t - ", problem), f_name, append = TRUE)
      warning(sprintf("Some trouble found in damaging tables. have a look to %s", f_name))
    }
  }
}
