#' Adjust model information in the table storey
#' 
#' @param data_table list of table informations of the model.
#' @return the storey table adjusted
#' 
#' @keywords internal

adjust_storey_03 = function(data_table) {

	# Ordering
	result = data_table[["storey"]]

	# Adjusting H_abs
	result = keep_df_order(result, merge, data_table[["building"]][c("building", "H", "height")], by = "building", suffixes = c("_x","_y"))
	selection = grep("^H_x$|^H_y$", names(result))
	result[["H_abs"]] = apply(result[selection], 1, sum, na.rm = TRUE)
	result[["H"]] = result[["H_x"]]
	result = result[-selection]

	# Adjusting height
	selection = grep("^height_x$|^height_y$", names(result))
	result[["height"]] = result[["height_x"]]
	result[["height"]][is.na(result[["height"]])] = result[["height_y"]][is.na(result[["height"]])]
	result = result[-selection]
				
	invisible(result)
}
