#' Adjust model information in the table room
#' 
#' @param data_table list of table informations of the model.
#' @return the room table adjusted
#' 
#' @keywords internal

adjust_room_03 = function(data_table) {
	area = function(coord) {splancs::areapl(as.matrix(coord))}

	# Ordering
	result = data_table[["room"]]

	# Adjusting H_abs
	result = keep_df_order(result, merge, data_table[["storey"]][c("building", "storey", "H", "height")], by = c("building", "storey"), suffixes = c("_x","_y"))
	selection = grep("^H_x$|^H_y$", names(result))
	result[["H_abs"]] = apply(result[selection], 1, sum, na.rm = TRUE)
	result[["H"]] = result[["H_x"]]
	result = result[-selection]

	# Adjusting height
	result[["height_storey"]] = result[["height"]]
	result[["height"]] = NULL

	# Caculating surface
	result[["surface"]] = sapply(split(data_table[["wall"]][c("x", "y")], data_table[["wall"]][["room"]]), area)[as.character(result[["room"]])]
				
	# Adding ceiling information
	ceiling = stats::setNames(
		data_table[["parameter"]][["ceiling"]],
		paste("ceiling", names(data_table[["parameter"]][["ceiling"]]), sep = "_")
	)
	result = keep_df_order(result, merge, ceiling, by.x = "ceiling", by.y = "ceiling_type", all.x = TRUE, suffixes = c("_x","_y"))

	# Adding floor information
	floor = stats::setNames(
		data_table[["parameter"]][["floor"]],
		paste("floor", names(data_table[["parameter"]][["floor"]]), sep = "_")
	)
	result = keep_df_order(result, merge, floor, by.x = "floor", by.y = "floor_type", all.x = TRUE, suffixes = c("_x","_y"))

	# Making elementary_component
	result[["floor_elementary_component"]] = compose_elementary_component("floor", result[["floor_material"]])
	result[["floor_insulating_elementary_component"]] = compose_elementary_component("floor", result[["floor_insulating"]], what = "insulating")
	result[["floor_coating_elementary_component"]] = compose_elementary_component("floor", result[["floor_coating"]], what = "coating")
	result[["ceiling_elementary_component"]] = compose_elementary_component("ceiling", result[["ceiling_material"]], what = "type")
	result[["ceiling_insulating_elementary_component"]] = compose_elementary_component("ceiling", result[["ceiling_insulating"]], what = "insulating")
	result[["ceiling_coating_elementary_component"]] = compose_elementary_component("ceiling", result[["ceiling_coating"]], what = "coating")

	invisible(result)
}

adjust_room_02 = function(data_table, version_building) {
	area = function(coord) {splancs::areapl(as.matrix(coord))}

	# Adjusting H_abs
	result = keep_df_order(data_table[["room"]], merge, data_table[["storey"]][c("storey", "H", "height")], by = "storey", suffixes = c("_x","_y"))
	# names(result) = gsub("\\.","_", names(result))
	selection = grep("^H_x$|^H_y$", names(result))
	result[["H_abs"]] = apply(result[selection], 1, sum, na.rm = TRUE)
	result[["H"]] = result[["H_x"]]
	result = result[-selection]
	result[["height_storey"]] = result[["height"]]
	result[["height"]] = NULL
	
	# Caculating surface
	result[["surface"]] = sapply(split(data_table[["wall"]][c("x", "y")], data_table[["wall"]][["room"]]), area)[as.character(result[["room"]])]
	
	# Adding ceiling information
	ceiling = stats::setNames(
		data_table[["parameter"]][["ceiling"]],
		paste("ceiling", names(data_table[["parameter"]][["ceiling"]]), sep = "_")
	)
	result = keep_df_order(result, merge, ceiling, by.x = "ceiling", by.y = "ceiling_type", all.x = TRUE, suffixes = c("_x","_y"))

	# Adding floor information
	if (version_building == "version_02") {
		floor = stats::setNames(
			data_table[["parameter"]][["floor"]],
			paste("floor", names(data_table[["parameter"]][["floor"]]), sep = "_")
		)
		result = keep_df_order(result, merge, floor, by.x = "floor", by.y = "floor_type", all.x = TRUE, suffixes = c("_x","_y"))
	}

	# Making elementary_component
	if (version_building == "version_02")	{
		result[["floor_elementary_component"]] = compose_elementary_component("floor", result[["floor_material"]])
		result[["floor_insulating_elementary_component"]] = compose_elementary_component("floor", result[["floor_insulating"]], what = "insulating")
		result[["floor_coating_elementary_component"]] = compose_elementary_component("floor", result[["floor_coating"]], what = "coating")
	} else {
		result[["floor_elementary_component"]] = compose_elementary_component("floor", result[["floor"]])
	}
	result[["ceiling_elementary_component"]] = compose_elementary_component("ceiling", result[["ceiling_material"]], what = "type")
	result[["ceiling_insulating_elementary_component"]] = compose_elementary_component("ceiling", result[["ceiling_insulating"]], what = "insulating")
	result[["ceiling_coating_elementary_component"]] = compose_elementary_component("ceiling", result[["ceiling_coating"]], what = "coating")
		
	invisible(result)
}
