#' Adjust model information in the table coating
#' 
#' @param data_table list of table informations of the model
#' @param file_log path of the file where to write log information
#' @return the coating table adjusted
#' 
#' @keywords internal

adjust_coating_03 = function(data_table, file_log) 
{
	calculate_coating_height = function(coating) {
		coating = coating[order(coating[["H_abs"]]),]
		coating[["height"]] = c(coating[["H_abs"]][-1], coating[["height_abs"]][1]) - coating[["H_abs"]]
		return(coating)
	}
	
	if (is.null(data_table[["coating"]])) return(NULL)

	# Adding parameter information
	result = keep_df_order(data_table[["coating"]], merge, data_table[["parameter"]][["coating"]], all.x = TRUE, by = "type")

	# Adjusting H_abs
	result = merge(result, data_table[["wall"]][c("building", "storey", "room", "wall", "H_abs", "height", "width")])
	result[["height_abs"]] = result[["height"]] + result[["H_abs"]]
	H = sapply(result[["H"]], function(x){if (is.na(x)) 0 else x})
	result[["H_abs"]] = H + result[["H_abs"]]

	# Checking H_abs and height
	selection = result[["H_abs"]] > result[["height_abs"]]
	if (any(selection)) {
		temp = split(result[selection,], droplevels(result[selection,][["material"]]))
		x = lapply(temp, function(x){apply(x[c("storey", "room", "wall")], 1, paste, collapse = "/")})
		report = c("\nSome coating are to high...", unlist(mapply(update_report, x, names(temp))))
		write(report, file = file_log, append = TRUE)
		warning(sprintf("Some coating are to high... Look at %s", file_log))
	}
	
	# Calculating height
	result = simplify2data_frame(
		mapply(calculate_coating_height, 
			split(result, result[c("building", "storey", "room", "wall")], drop = TRUE),
			SIMPLIFY = FALSE))
	result = result[order(result[["building"]], result[["storey"]], result[["room"]], result[["wall"]], result[["height"]]), ]
	
#~ 	result[["height"]] = NULL
	
	#Calculating surface
	result[["surface"]] = result[["height"]] / 100 * result[["width"]]

	# Making elementary_component
	result[["coating_elementary_component"]] = compose_elementary_component("wall_coating", result[["material"]])

	invisible(result)
}
	
adjust_coating_02 = function(data_table, file_log)
{
	if (is.null(data_table[["coating"]])) {
		return(NULL)
	}

	calculate_coating_height = function(coating) {
		coating = coating[order(coating[["H_abs"]]),]
		coating[["height"]] = c(coating[["H_abs"]][-1], coating[["height_abs"]][1]) - coating[["H_abs"]]
		return(coating)
	}
	
	# Adjusting H_abs
	result = merge(
		data_table[["coating"]],
		data_table[["wall"]][c("storey", "room", "wall", "id_wall", "H_abs", "height", "width")]
	)
	result[["height_abs"]] = result[["height"]] + result[["H_abs"]]
	result[["H"]] = sapply(result[["H"]], function(x){if (is.na(x)) 0 else x})
	result[["H_abs"]] = result[["H"]] + result[["H_abs"]]

	# Checking H_abs and height
	selection = result[["H_abs"]] > result[["height_abs"]]
	if (any(selection)) {
		temp = split(result[selection,], droplevels(result[selection,][["material"]]))
		x = lapply(temp, function(x){apply(x[c("storey", "room", "wall")], 1, paste, collapse = "/")})
		report = c("\nSome coating are too high...", unlist(mapply(update_report, x, names(temp))))
		write(
			report,
			file = file_log,
			append = TRUE
		)
		warning(
			sprintf(
				"Some coating are to high... Look at %s",
				file_log
			)
		)
	}
	
	# Calculating height
	result = simplify2data_frame(
		mapply(
			calculate_coating_height, 
			split(result, result[c("storey", "room", "wall")], drop = TRUE),
			SIMPLIFY = FALSE
		)
	)
	
	# Calculating surface
	result[["surface"]] = result[["height"]] / 100 * result[["width"]]

	# Making elementary_component
	result[["coating_elementary_component"]] = compose_elementary_component("wall_coating", result[["material"]])

	result = result[order(result[["storey"]], result[["room"]], result[["wall"]], result[["height"]]), ]
	invisible(result)
}
	
