test_that("Test model is correctly loaded",
    {
        expect_s3_class(adu_t, "model")
        expect_s3_class(adu_l, "model")
        expect_s3_class(adu_t_basement, "model")
        expect_s3_class(adu_t_2room, "model")
        expect_s3_class(adu_t_invisible, "model")
        expect_s3_class(adu_elevator, "model")
    }
)

test_that("Test model can be correctly analyzed",
    {
        adu_path = list(
            data = system.file("extdata", package = "floodam.building"),
            output = adu_t[["path"]][["output"]]
        )

        # adu_t
        load_test = expect_no_message(
            analyse_model(
                model = "adu_t",
                type = "adu",
                path = adu_path,
                stage = c("load", "extract", "damaging", "hydraulic"),
                verbose = FALSE
            )
        )
        load_test[["path"]] =  adu_t[["path"]]
        expect_identical(adu_t, load_test)

        # adu_l
        adu_l = expect_no_warning(
            analyse_model(
                model = adu_l,
                stage = c("extract", "damaging", "hydraulic"),
                verbose = FALSE
            )
        )
        load_test = expect_no_message(
            analyse_model(
                model = "adu_l",
                type = "adu",
                path = adu_path,
                stage = c("load", "extract", "damaging", "hydraulic"),
                verbose = FALSE
            )
        )
        load_test[["path"]] =  adu_l[["path"]]
        expect_identical(adu_l, load_test)

        # adu_basement
        adu_t_basement = expect_no_warning(
            analyse_model(
                model = adu_t_basement,
                stage = c("extract", "damaging", "hydraulic"),
                verbose = FALSE
            )
        )
        load_test = expect_no_message(
            analyse_model(
                model = "adu_t_basement",
                type = "adu",
                path = adu_path,
                stage = c("load", "extract", "damaging", "hydraulic"),
                verbose = FALSE
            )
        )
        load_test[["path"]] =  adu_t_basement[["path"]]
        expect_identical(adu_t_basement, load_test)

        # adu_t_2room
        adu_t_2room = expect_no_warning(
             analyse_model(
                model = adu_t_2room,
                stage = c("extract", "damaging", "hydraulic"),
                verbose = FALSE
            )
        )
        load_test = expect_no_message(
            analyse_model(
                model = "adu_t_2room",
                type = "adu",
                path = adu_path,
                stage = c("load", "extract", "damaging", "hydraulic"),
                verbose = FALSE
            )
        )
        load_test[["path"]] =  adu_t_2room[["path"]]
        expect_identical(adu_t_2room, load_test)

        # adu_t_invidible
        adu_t_invisible = expect_no_warning(
             analyse_model(
                model = adu_t_invisible,
                stage = c("extract", "damaging", "hydraulic"),
                verbose = FALSE
            )
        )
        load_test = expect_no_message(
            analyse_model(
                model = "adu_t_invisible",
                type = "adu",
                path = adu_path,
                stage = c("load", "extract", "damaging", "hydraulic"),
                verbose = FALSE
            )
        )
        load_test[["path"]] =  adu_t_invisible[["path"]]
        expect_identical(adu_t_invisible, load_test)

        # adu_elevator
        adu_elevator = expect_no_warning(
             analyse_model(
                model = adu_elevator,
                stage = c("extract", "damaging", "hydraulic"),
                verbose = FALSE
            )
        )
        load_test = expect_no_message(
            analyse_model(
                model = "adu_elevator",
                type = "adu",
                path = adu_path,
                stage = c("load", "extract", "damaging", "hydraulic"),
                verbose = FALSE
            )
        )
        load_test[["path"]] =  adu_elevator[["path"]]
        expect_identical(adu_elevator, load_test)
    }
)

test_that("Test warning when analyzing models including elementary components 
            missing in the database",
    {
        output_dir = tempdir()
        expected_warning = sprintf(
            "%s elementary component(s) do not have damaging functions! ",
            5
        )

        expect_warning(
            adu_t_missing <- analyse_model(
                model = "adu_t_missing",
                type = "adu",
                path = init_create_path(
                    input = system.file(
                        "extdata", 
                        package = "floodam.building"
                    ),
                    output = output_dir
                ),
                stage = c("load", "extract", "damaging"),
                version_building = NULL,
                verbose = FALSE
            ),
            expected_warning,
            fixed = TRUE
        )
    }
)

test_that("test a very simple model with floor component duplicated",
    {
        output_dir = tempdir()
        expected_warning = "Items with identical names detected in"

        expect_warning(
            adu_component_repeated <- load_model(
                model_name = "adu_component_repeated",
                type = "adu",
                path = init_create_path(
                    input = system.file(
                        "extdata", 
                        package = "floodam.building"
                    ),
                    output = output_dir
                ),
                verbose = FALSE
            ),
            expected_warning
        )
    }    
)
