test_that("Test inspect_building",
    {
        # Minimal model that is inspected without error
        model = list(
            building = list(
                "general" = list(
                    "type" = "test",
                    "H" = 0,
                    "height" = 0,
                    "dilapidation" = 0,
                    "version" = "test"
                ),
                "element" =  list(
                    "ceiling" = list(
                        "ceiling" = list(
                            "material" = "test",
                            "H" = 0
                        )
                    ),
                    "wall" = list(
                        "load_bearing_wall" = list(
                            "wall_type" = "test",
                            "material" = "test"
                        )
                    )
                ),
                "building" = list(
                    "storey" = list(
                        "H" = 0,
                        "external" = list(
                            "wall" = list(
                                "coordinates" = as.numeric(1:2),
                                "type" = "test"
                            )
                        ),
                        "room" = list(
                            "wall" = list(
                                "coordinates" = as.numeric(1:2),
                                "type" = "test"
                            )
                        )
                    )
                )
            ),
            "name" = "test",
            "path" = list("model_log" = tempdir()),
            "file_name" = list("log" = "test.log", "building" = "test.yaml")
        )

        message_expected = sprintf(
            "\t- Structure of %s of '%s' has been successfully checked",
            model[["file_name"]][["building"]],
            model[["name"]]
        )
        result = expect_message(expect_no_error(inspect_building(model)), message_expected)

        # Minimal model that generates error
        model_bad = list(
            building = list(),
            "name" = "test",
            "path" = list("model_log" = tempdir()),
            "file_name" = list("log" = "test.log", "building" = "test.yaml")
        )

        error_expected = sprintf(
            "%s has some troubles. Look at %s",
            model_bad[["file_name"]][["building"]],
            file.path(model_bad[["path"]][["model_log"]], model_bad[["file_name"]][["log"]])
        )
        expect_no_message(expect_error(inspect_building(model_bad, verbose = FALSE), error_expected))

        # Minimal model that generates error
        model_bad = model
        model_bad[["building"]][["building"]][["storey"]][["room"]] = c(
            model_bad[["building"]][["building"]][["storey"]][["room"]],
            model_bad[["building"]][["building"]][["storey"]][["room"]]
        )
        # inspect_building(model_bad, verbose = TRUE)
    }
)
