test_that("Test construct_report",
    {
        # WARNING
        # those tests depend heavily on inst/extdata/parameter/building.yaml
        # If this file is change and BUILDING is updated, there is a lot of
        # chance that some tests may need to be adapted

        pattern = BUILDING[["version_02"]]

        # element with sufficient information but of bad type
        wall = list(coordinates = integer(), type = "wall")
        p_wall = pattern[["building"]][["storey"]][["generic"]][["wall"]]
        expected = c(
            "Trouble with type in 'test' for the following elements:",
            "\t- coordinates"
        )
        expect_equal(construct_report(wall, p_wall, "test"), expected)

        # element with missing information, other OK
        wall = list(type = "wall")
        expected = c(
            "Each of following elements are missing in 'test':",
            "\t- coordinates"
        )
        expect_equal(construct_report(wall, p_wall, "test"), expected)

        # element with sufficient information of good types
        wall = list(coordinates = numeric(), type = "wall")
        expect_equal(construct_report(wall, p_wall, "test"), NULL)

        # 2 elements that need to be local ID but are not
        room = list(wall = wall, wall = wall)
        p_room = pattern[["building"]][["storey"]][["generic"]]
        expected = c(
            "Those elements have several occurrences with the same name in 'test' but should be local ID:",
            "\t- wall"
        )
        expect_equal(construct_report(room, p_room, "test"), expected)

        # 2 elements that need to be local ID and are (with same name in 2 different locations)
        room = list(wall = wall)
        storey = list(H = numeric(), external = room, room = room)
        p_storey = pattern[["building"]][["storey"]]
        expect_equal(construct_report(storey, p_storey, "test"), NULL)

        # 2 elements that need to be global ID but are not
        building = list(
            storey_1 = list(H = numeric(), external_1 = room, room = room),
            storey_2 = list(H = numeric(), external_2 = room, room = room)
        )
        p_building = pattern[["building"]]
        expected = c(
            "Some rooms have duplicated name in 'test':",
            "\t- room"
        )
        expect_equal(construct_report(building, p_building, "test"), expected)
    }
)


