% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hydraulic_damage.R
\name{get_hydraulic_damage}
\alias{get_hydraulic_damage}
\title{Find the damage total of the model based on the hydraulic simulation}
\usage{
get_hydraulic_damage(
  h_max_by_room,
  damage,
  exposition,
  threshold_height = 1,
  threshold_duration = 12
)
}
\arguments{
\item{h_max_by_room}{vector of doubles, max water level by room}

\item{damage}{damaging part of an object of class model}

\item{exposition}{character or list of characters, giving the names of the
walls concerned by external limnigraphs}

\item{threshold_height}{numeric, height in centimeters above which a damage
is considered}

\item{threshold_duration}{numeric, maximum duration for the damage function
used for interpolation. See details.}
}
\value{
matrix, damages for each rooms and externals based on water level
}
\description{
Find the damage total of the model based on the hydraulic simulation
}
\details{
The damage functions used for interpolation are those with the smallest
positive duration available in \code{damage}. This minimum must be less than or
equal to \code{threshold_duration}. If this is not the case, an error is returned
to force the user to construct the damage functions with \code{analyse_model()}
using a \code{hazard_range} consistent with the needs of the hydraulic analysis.
}
\examples{

model = adu_t

# generate limnigraph
flood = generate_limnigraph(
	 model = model,
  time = c(0, 300, 900),
  depth = cbind(facade = c(0, 3, 0)),
  exposition = list(
    facade = list(external = c("wall_A", "wall_B", "wall_C", "wall_D", "wall_E",
		"wall_F", "wall_G", "wall_H")))
)
# calculate maximum flood water depth for event in "flood" in model adu_t
hydraulic = analyse_hydraulic(
	model = model,
	limnigraph = flood,
	sim_id = "test",
	stage = c("hydraulic")
)
# calculate damage for flood water depth calculated with hydraulic model
get_hydraulic_damage(
 h_max_by_room = hydraulic$hmax["z",], 
 damage = model[["dam_room_wall"]][c("absolute_room","absolute_external")], 
 exposition = flood[["exposition"]]
)

# Test of some thresholds
hmax = c(room_1 = 0, room_1 = 0.005, room_1 = 0.2, room_1 = 0.12, room_1 = 10.0)
dam = list()
dam[["absolute_room"]][["room_1"]][["total"]] = matrix(
 c(0, 0, 0, 0, 1000, 2000, 0, 1500, 2500),
 ncol = 3, byrow = FALSE,
 dimnames = list(h = c(0, 10, 20), d = c(0, 12, 40))
)
get_hydraulic_damage(hmax, dam, NULL)

}
