% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_damage_detail_by_room.R
\name{extract_elementary_component_from_detail}
\alias{extract_elementary_component_from_detail}
\title{Extract elementary damages by categories of elementary components}
\usage{
extract_elementary_component_from_detail(x, what, room)
}
\arguments{
\item{x}{list of \code{elementary_damaging} objects}

\item{what}{character, the name of the category to be extracted}

\item{room}{character, name of the room for which \code{elementary_damaging} will
be extracted.}
}
\value{
a list of \code{elementary_damaging} objects
}
\description{
Extract elementary damages by categories of elementary components (floor,
ceiling, wall, opening, coating and furniture).
}
\details{
This function is meant to be called during the calculation of damage
functions
}
\examples{
# example for the category "wall" in "room_1"
test = extract_elementary_component_from_detail(
 x = adu_t[["damaging"]][["detail"]], 
 what = "wall",
 room = "room_1"
)

}
\seealso{
\code{\link[=extract_damage_detail_by_room]{extract_damage_detail_by_room()}} and
\code{\link[=extract_damage_detail_external]{extract_damage_detail_external()}}, to handle the calculation of
damage functions by rooms
}
