% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_damage_detail_by_room.R
\name{extract_damage_detail_by_room}
\alias{extract_damage_detail_by_room}
\title{Extract elementary damages by room}
\usage{
extract_damage_detail_by_room(x, room)
}
\arguments{
\item{x}{the list of elementary damaging in a model, as given in
the slot "detail" of the slot "damaging" of a model}

\item{room}{character, names of the rooms in the model}
}
\value{
a list
}
\description{
Extract elementary damages by room
}
\details{
This function is meant to be called during the calculation of damage
functions
}
\examples{
model = analyse_model(
 model = adu_t_basement,
 stage = c("extract", "damaging")
)

test = extract_damage_detail_by_room(
 x = model[["damaging"]][["detail"]], 
 room = levels(model[["data_table"]][["room"]][["room"]])
)

}
\seealso{
\code{\link[=extract_elementary_component_from_detail]{extract_elementary_component_from_detail()}} and
\code{\link[=extract_damage_detail_external]{extract_damage_detail_external()}}, to handle the calculation of
damage functions by rooms and walls
}
