% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_danger.R
\name{compute_danger}
\alias{compute_danger}
\title{Analyse the dangerosity of the simulation}
\usage{
compute_danger(result_h, opening, room, bound, dt_max, t_max)
}
\arguments{
\item{result_h}{matrix containg water level in rooms associated with their
time}

\item{opening}{hydraulic part of the model, containing informations on the
exchange}

\item{room}{hydraulic part of the model, containing informations on the
rooms}

\item{bound}{numeric, matrix of floodwater depth heights by instant t
for each exterior opening exposed to flooding}

\item{dt_max}{numeric, optional; maxmimum timestep for simulation}

\item{t_max}{numeric, duration of the flood event in seconds,
optional; if not provided, calculated using limnigraph}
}
\value{
matrix of dangerosity for all openings
}
\description{
Analyse the dangerosity of the simulation
}
