% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_damage.R
\name{compute_damage_from_detail}
\alias{compute_damage_from_detail}
\title{Aggregates damage from detailed list of elementary damaging functions}
\usage{
compute_damage_from_detail(
  x,
  category,
  hazard_range = getOption("floodam_building_hazard_range")
)
}
\arguments{
\item{x, }{list of \code{elementary_damaging} objects}

\item{category, }{character indicating the model category}

\item{hazard_range}{list, default to
getOption("floodam_building_hazard_range")}
}
\value{
a list of objects of class "damaging"
}
\description{
Aggregates detailed list of elementary damaging functions by category (total,
building and furniture) .
}
\details{
This funtion is meant to be called during the execution of the function
\code{compute_damage()}. It ensures that damages are calculated consistently
across levels of aggregation : external wall segments, external walls, rooms
and building level.

\if{html}{\out{<div class="sourceCode">}}\preformatted{It serves as a bridge between `compute_damage()` and `sumup_damage()`, 
}\if{html}{\out{</div>}}

providing the latter the right list of elementary damaging components to use
}
\examples{
\dontrun{
	result[["absolute"]] = compute_damage_from_detail(
		x = result[["detail"]],
		category = category,
		hazard_range = hazard_range
	)
}

}
\keyword{internal}
