% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_damage_by_room_wall.R
\name{compute_damage_by_room_wall}
\alias{compute_damage_by_room_wall}
\title{Compute damage by room and segment of external wall in a given model}
\usage{
compute_damage_by_room_wall(
  model = model,
  hazard_range = getOption("floodam_building_hazard_range"),
  dam = floodam.building::DAM,
  h_abs = "room",
  verbose = getOption("floodam_building_verbose")
)
}
\arguments{
\item{model}{model}

\item{hazard_range}{list, default to
getOption("floodam_building_hazard_range")}

\item{dam}{list, default to floodam.building::DAM}

\item{h_abs}{character, default to "room". See details}

\item{verbose}{logical, default to getOption("floodam_building_verbose")}
}
\value{
a list containing the computed absolute damage by room and external
wall segment.  The list has two elements:
\itemize{
\item \code{absolute_room}: A list where each element represents the damage
for a specific room.
\item \code{absolute_external}: A list where each element represents the damage
for a specific external wall segment.
}
}
\description{
This function computes damage by room and external wall segment in a provided
model. It calculates damage by, first, grouping elementary components by room
and segment of external, and calculating the absolute damage for the given
hazard range
}
\details{
The function has only been tested for version 02 of building input file.

The h_abs parameter is used to control whether calculations are performed
using the original level at which the room and external walls are located in
the building (h_abs = "model"), or an alternative level that disregards the
room's floor level in relation to street level and sets the room's floor to
zero (h_abs = "room").
}
\examples{

model = analyse_model(adu_t_basement, stage = "extract")
model[["dam_room_wall"]] = compute_damage_by_room_wall(
	model = model
)

model[["dam_room_wall"]] = compute_damage_by_room_wall(
	model = model,
 h_abs = "model"
)

}
