% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_wall_width.R
\name{calculate_wall_width_02}
\alias{calculate_wall_width_02}
\alias{calculate_wall_width_03}
\title{calculate walls width}
\usage{
calculate_wall_width_02(wall)

calculate_wall_width_03(wall)
}
\arguments{
\item{wall}{data.frame of walls characteristics, supposed to be in a ‘correct
order’. See details.}
}
\value{
vector of walls widths
}
\description{
\code{calculate_wall_width_02()} and \code{calculate_wall_width_03()} are \strong{internal}
functions that calculate  widths for walls.

Beware that walls sould be described in a data.frame with some expected
columns:
\itemize{
\item \code{building} (only for \code{calculate_wall_width_03()})
\item \code{storey}
\item \code{room}
\item \code{x}
\item \code{y}
}

The ‘correct order’ of the walls means that the order of the lines should
recreate the natural order in which the walls of a given room are arranged.
The \code{x} and \code{y} co-ordinates only give the starting point of a wall, the end
point of the wall is given by the co-ordinates of the next line.
}
\examples{

data_table = extract_building_information(adu_t)

# Lazy
floodam.building:::calculate_wall_width_02(data_table[["wall"]])

# Better
floodam.building:::calculate_wall_width_02(data_table[["wall"]][c("storey", "room", "x", "y")])

}
\keyword{internal}
