## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk[["set"]](
  collapse = TRUE,
  comment = "#>",
  fig.align = "center"
)

## ----setup--------------------------------------------------------------------
#> Loading required package: floodam.building
library(floodam.building)

#> set up model to use example shipped with floodam
model_path = list(
data = system.file("extdata", package = "floodam.building"),
output = tempdir()
)

## ----model--------------------------------------------------------------------
model = analyse_model(
  model = "adu_t",
  type = "adu",
  stage = c("load", "extract", "damaging"),
  path = model_path
)

## ----plan, fig.height=5.6, fig.width=7.1--------------------------------------
#> visualization of the house's plan
plot(model, view = "top")

## ----damage-plot, fig.height=8, fig.width=9-----------------------------------
#> visualization of the house's damage function
plot(model, view = "damaging")

## ----damage-table-------------------------------------------------------------
#> visualization of the house's damage function
head(model[["damaging"]][["absolute"]][["total"]], 10) |> knitr::kable()

