#' Update value used for extrapolation based on esane data base
#' 
#' @param path where to find the data
#' @param path_output where to write the data
#' @param base base typology
#' @param transport data on transport
#' @return updated data used for extrapolation
#' 
#' @export

update_esane = function(
		path = file.path("data", "INSEE", "esane"), 
		path_output = file.path(update_path(type = "activity")[["extrapolation"]], "esane.csv"),
		base = utils::read.csv2("data-floodam/extrapolation/activity/esane/typology.csv"),
		transport = utils::read.csv2("output-floodam/analysis/esane/transport.csv", row.names = 1)
	)
{
	path_input = file.path(path, "mean")
	
#~ 	base = base[!is.na(base[["category"]]), ]
	
	employee = c("EMPSALNOMESS")
	enterprise = c("ACTENTNOMESS")
	equipment = c("BAC123VALESE", "BAC124VALESE")
	stock = c("BAC152VALESE", "BAC155VALESE", "BAC156VALESE")
	fields = c(enterprise, employee, equipment, stock)
	
	ape = utils::read.csv2(file.path(path, "ape.csv"))
	
	level = "N5"
	result = utils::read.csv2(file.path(path_input, sprintf("esane-mean-%s.csv", level)) , row.names = 1)[, fields]
	result[["APE_05"]] = row.names(result)
	result = merge(base, result, by = "APE_05", all.x = TRUE)
	result[["level"]] = level
	row.names(result) = result[["APE_05"]]
	selection = row.names(result)[apply(result[fields], 1, function(x){any(is.na(x))})]
	
	for (level in c("N3", "N2", "N1", "N0")) {
		if (length(selection) > 0) {
			complement = utils::read.csv2(file.path(path_input, sprintf("esane-mean-%s.csv", level)), row.names = 1)[fields]
			complement["code"] = row.names(complement)
			complement = merge(ape[c("N5", level)], complement, by.x = level, by.y = "code", all.x = TRUE)
			row.names(complement) = complement[["N5"]]
			result[selection, fields] = complement[selection, fields]
			result[selection, "level"] = level
			selection = row.names(result)[apply(result[fields], 1, function(x){any(is.na(x))})]
		}
	}

	if (length(selection) > 0) {
		result[selection, "level"] = "no data"
	}
	
	# Special treatment for financial services and some office...
	selection = result[["level"]] == "no data" & result[["type"]] == "activity" & (result[["category"]] == "financial_service" | result[["category"]] == "office")
	selection[is.na(selection)] = FALSE
	selection = row.names(result)[selection]
	complement = utils::read.csv2(file.path(path_input, sprintf("esane-mean-N1.csv", level)), row.names = 1)["M", fields]
	result[selection, fields] = complement
	result[selection, "level"] = "extrapolation"

	# Special treatment for medical service
	selection = result[["level"]]  == "no data" & result[["type"]] == "activity" & result[["category"]] == "medical_service"
	selection[is.na(selection)] = FALSE
	selection = row.names(result)[selection]
	complement = utils::read.csv2(file.path(path_input, sprintf("esane-mean-N5.csv", level)), row.names = 1)["7500Z", fields] # Les vétérinaires
	result[selection, fields] = complement
	result[selection, "level"] = "extrapolation"

	# Preparing finalized data
	result[["n"]] = apply(result[, enterprise , drop = FALSE], 1, sum)
	result[["employee"]] = apply(result[, employee , drop = FALSE], 1, sum)
	result[["equipment"]] = apply(result[, equipment , drop = FALSE], 1, sum)
	result[["stock"]] = apply(result[, stock , drop = FALSE], 1, sum)

	# Adding information on transport
	transport[["APE_05"]] = row.names(transport)
	result = merge(result, transport[c("APE_05", "transport")], all.x = TRUE)
	
	# Final step
	transport = result[["transport"]]
	transport[is.na(transport)] = 0
	
	result[["s_emp"]] = result[["stock"]] / (result[["n"]] + result[["employee"]])
	result[["e_emp"]] = result[["equipment"]] * (1 - transport) * (1 - result[["leased"]]) / (result[["n"]] + result[["employee"]])
	result[["s_ent"]] = result[["stock"]] / result[["n"]]
	result[["e_ent"]] = result[["equipment"]] * (1 - transport) * (1 - result[["leased"]]) / result[["n"]]
	
	result[["virtual_corrected"]] = 0
	
	# Special treatment for office
	selection = result[["category"]] == "office"
	selection[is.na(selection)] = FALSE
	
	sub_selection = 
		result[["e_emp"]][selection] > 5 * stats::median(result[["e_emp"]][selection], na.rm = TRUE) |
		result[["e_emp"]][selection] < 0
	sub_selection[is.na(sub_selection)] = TRUE
	result[["e_emp"]][selection][sub_selection] = stats::median(result[["e_emp"]][selection], na.rm = TRUE)
	result[["virtual_corrected"]][selection][sub_selection] = 1
	
	sub_selection = 
		result[["s_emp"]][selection] > 5 * stats::median(result[["s_emp"]][selection], na.rm = TRUE) |
		result[["s_emp"]][selection] < 0
	sub_selection[is.na(sub_selection)] = TRUE
	result[["s_emp"]][selection][sub_selection] = stats::median(result[["s_emp"]][selection], na.rm = TRUE)
	result[["virtual_corrected"]][selection][sub_selection] = 1
	
	interest = c("level", "n", "employee", "equipment", "stock", "transport", "virtual_corrected", "e_emp", "s_emp", "e_ent", "s_ent")
	# Ordering everything
	result = result[order(result[["APE_05"]]), c(names(base), interest, fields)]

	utils::write.csv2(result, path_output, row.names = FALSE)
	invisible(result)
}
