#' Update damaging function for a given category
#' 
#' @param category name of the category to be updated
#' @param category_model data.frame
#' @param path list of useful path
#' @param file_name character, unused
#' @param verbose logical
#' @return a data.frame of damaging function for building, equipment, and stock components, and of surface damage for building
#' 
#' @keywords internal

update_category_damaging = function(category, category_model, path, file_name, verbose = TRUE) {
	
	start = Sys.time()
	if (verbose) message(sprintf("Updating %s...\n", category))

	path_category = file.path(path[["category_output"]], category)
	dir.create(path_category, showWarnings = FALSE, recursive = TRUE)
	model = category_model[category_model[["category"]] == category, "model_name"]
	model = lapply(file.path(path[["model_output"]], model, paste(model, "damaging.csv", sep = "-")), utils::read.csv2)
	model = lapply(model, calculate_weight_building, "relative")
	names(model) = category_model[category_model[["category"]] == category, "model_name"]
	
	# Transform data.frame in list of matrices of damaging functions		
	model = lapply(model, damaging_as_matrix)
	
	output_damaging = c("relative_building", "relative_equipment", "relative_stock", "surface_building", "weight_relative_building")
	result = list()
	for (o in output_damaging) {
		temp = lapply(model, function(x){x[[o]]})
		temp[["mean"]] = apply(simplify2array(temp), 1:2, mean)
		try(plot_relative_damaging(temp, output = path_category, name = o))
		result[[o]] = temp[["mean"]]
	}
	
	result = summarize_category_damaging(result)
	utils::write.csv2(result, file.path(path_category, "damaging.csv"), row.names = FALSE)
	
	duration = Sys.time() - start
	if (verbose) message(sprintf("\t... Elapsed time %.2f %s\n", duration, attr(duration, "units")))
	invisible(result)
}
