#' Update analysis of results from floodam. Subject to many changes...
#' 
#' @param type character, type of model that is loaded, default to NULL
#' @param path list of useful paths, default to getOption("floodam_building_path")
#' @param file_name, list of useful file names, default to getOption("floodam_building_file_name")
#' @param sel character, models to be selected within type, default to NULL (everything is selected)
#' @param skip character, models not to be selected within types, default to NULL (nothing is skipped)
#' @return NULL
#' @examples
#' \dontrun{
#' update_analysis(type = "activity")
#' }
#' 
#' @export


update_analysis = function(
		type,
		path = getOption("floodam_building_path"),
		file_name = getOption("floodam_building_file_name"),
		sel = NULL,
		skip = NULL
	)
{
	activity = floodam.building::ACTIVITY

	# Analyzing damaging functions at model level	
	path = update_path(type = type, path = path)
	model = dir(path[["model_output"]])[-grep("csv", dir(path[["model_output"]]))]
	
	if (!is.null(sel)) {
		missing = sel[!(sel %in% model)]
		model =  sel[sel %in% model]
		if (length(missing) > 0) warning(sprintf("Those models (%s) are not in %s. Not evaluated.", paste(missing, collapse = ", "), path[["model_output"]]))
	} else if (!is.null(skip)) {
		model = model[!(model %in% skip)]
	}
	
	damaging = lapply(file.path(path[["model_output"]], model, paste(model, "damaging.csv", sep = "-")), utils::read.csv2)
	damaging = lapply(damaging, calculate_weight_building, "relative")
	damaging = lapply(damaging, calculate_weight_building, "absolute")
	names(damaging) = model
	damaging = lapply(damaging, damaging_as_matrix)
	
	what = names(damaging[[1]])
	weight = grep("weight", what)
	lapply(what[-weight], plot_analysis_damaging, 
		damaging = damaging, d_select = c(12, 120), 
		output = path[["analysis_model"]], 
		group = as.character(activity[["category"]][names(damaging), "category"]))
	lapply(what[weight], plot_analysis_damaging, 
		damaging = damaging, d_select = c(12, 120), ref = .1,
		output = path[["analysis_model"]], 
		group = as.character(activity[["category"]][names(damaging), "category"]))

	# Analyzing Esane
	# update_esane(path)
	
	if (type == "activity") {
		analyse_esane(path, levels(activity[["category"]][["APE_05"]]), sub_path = "model")

		for (category in levels(activity[["esane"]][["category"]])) {
			selection = as.character(activity[["esane"]][["APE_05"]][activity[["esane"]][["category"]] == category])
			selection = selection[!is.na(selection)]
			sub_path = file.path("category", category)
			analyse_esane(path, selection, sub_path)
		}
	}
	
	invisible(NULL)
}


