#' Summarize category damaging function
#' 
#' @param damaging array of model damaging, detailed by component
#' @return a data.frame of damages summed by action, with NA only where no numeric value is available
#' 
#' @keywords internal

summarize_category_damaging = function(damaging)
{
	result = data.frame(
		h = rep(as.numeric(dimnames(damaging[["relative_building"]])[["h"]]), times = length(dimnames(damaging[["relative_building"]])[["d"]])),
		d = rep(as.numeric(dimnames(damaging[["relative_building"]])[["d"]]), each = length(dimnames(damaging[["relative_building"]])[["h"]]))
	)
	
	cbind(result, 
		relative_building = as.vector(damaging[["relative_building"]]),
		relative_equipment = as.vector(damaging[["relative_equipment"]]),
		relative_stock = as.vector(damaging[["relative_stock"]]),
		surface_building = as.vector(damaging[["surface_building"]])
	)
}
