#' Prepare the material modification by creating a list of the new elements and a table of 
#' correspondence for the changes in the building
#' 
#' @param model the model to which measures will be applied
#' @param type the type of element concerned by the measure
#' @param l_part the list of the different part of the type concerned by the measure
#' @return a list with the new elements and the table of correspondence
#' 
#' @keywords internal

prepare_substitution = function(model, type, l_part) {

prepare_substitute_element = function(element, type, l_part) {	
	result = NULL
	temp = list()
	#Floor coating is dependent on floor material
	if (type == "floor"){ 
	  #Change of material
	  if ("material" %in% names(l_part)){
	    if (element[["material"]] %in% l_part[["material"]][["origin"]]) {
	      temp[["material"]] = as.character(l_part[["material"]][l_part[["material"]][["origin"]] == element[["material"]], "final"])
	    }
	  }
	  #Verification of floor material and change of coating if need be
	  condition = list(concrete = c("concrete"), wood = c("joist_board", "joist_vault"))
	  if ("coating" %in% names(l_part) & "coating" %in% names(element)){
	    if (element[["coating"]] %in% l_part[["coating"]][["origin"]]){
	      elem_coat = l_part[["coating"]][grep(element[["coating"]], l_part[["coating"]][["origin"]]),]
	      for (i in 1:length(elem_coat)){
	         if (length(temp[["material"]]) != 0){
	          if (temp[["material"]] %in% condition[[elem_coat[["condition"]][i]]]){
	            temp[["coating"]] = as.character(elem_coat[i, "final"])
	          }
	         } else {
	           if (element[["material"]] %in% condition[[elem_coat[["condition"]][i]]]){
	             temp[["coating"]] = as.character(elem_coat[i, "final"])
	           }
	         } 
	       }
	    }
	  }
	} else {
	  for (what in names(l_part)) {
		  if (what %in% names(element)) {
			  if (element[[what]] %in% l_part[[what]][["origin"]]) {
				if (paste(type, "type", sep = "_") %in% names(element) & "sub_type" %in% names(l_part[[what]])){
			    	temp[[what]] = as.character(l_part[[what]][l_part[[what]][["origin"]] == element[[what]] & l_part[[what]][["sub_type"]] == element[[paste(type, "type", sep = "_")]], "final"])
				} else {temp[[what]] = as.character(l_part[[what]][l_part[[what]][["origin"]] == element[[what]], "final"])}
			  }
			}
		}
	}
	if (length(temp) > 0) {
		result = element
		result[names(temp)] = temp
	}
	return(result)
}


	new_element = lapply(model[["building"]][["element"]][[type]], prepare_substitute_element, type, l_part)
	new_element = new_element[!sapply(new_element, is.null)]
	
	if (length(new_element) == 0){
	  correspondence=list()
	} else {
	
	  name = split(names(model[["building"]][["element"]][[type]]), gsub("[_][0-9]+", "", names(model[["building"]][["element"]][[type]])))
	  name = mapply(function(x, y){max(as.numeric(gsub(sprintf("^%s.", y), "", x)))}, name, names(name))
	
	  correspondence = data.frame(origin = names(new_element), final = as.character(NA), stringsAsFactors = FALSE)
	  for (i in seq(nrow(correspondence))) {
		  what = gsub("[_][0-9]+", "", correspondence[i, "origin"])
		  name[what] = name[what] + 1
		  correspondence[i, "final"] = paste(what, name[what], sep ="_")
	  }
	
	  names(new_element) = correspondence[["final"]]
	}
	
	return(list(new_element = new_element, correspondence = correspondence))

}

