#' Apply the measures on the building values and create the new tables
#' 
#' @param model the model to which measures will be applied
#' @param measure the list of measures applied to the model
#' @param selection the rooms or height for which measures will be applied
#' @return the model with the changes on the XML and tables data due to the measures
#' 
#' @keywords internal

modify_material = function(model, measure, selection) {
# 1. check presence in element and create the tables of correspondence
  #Create an empty correspondence list
  correspondence = list()
  
  #Split the list of measures on material by type
  l_type = split(measure[["material"]], measure[["material"]][["type"]], drop = TRUE)
  
  
  #Baseboard 
  # Uncomment when baseboard taken into account
  # if ("baseboard" %in% names(l_type)){
  #   l_part = split(l_type[["baseboard"]], l_type[["baseboard"]][["part"]], drop = TRUE)
  #   baseboard = prepare_substitution(model, "baseboard", l_part)
  #   if (length(baseboard[["correspondence"]]) != 0){
  #     correspondence[["baseboard"]] = baseboard[["correspondence"]]
  #     model[["building"]][["element"]][["baseboard"]] = c(model[["building"]][["element"]][["baseboard"]], baseboard[["new_element"]])
  #   }
  # }
  
  #Ceiling
  if ("ceiling" %in% names(l_type)){
    l_part = split(l_type[["ceiling"]], l_type[["ceiling"]][["part"]], drop = TRUE)
    ceiling = prepare_substitution(model, "ceiling", l_part)
    if (length(ceiling[["correspondence"]]) != 0){
      correspondence[["ceiling"]] = ceiling[["correspondence"]]
      model[["building"]][["element"]][["ceiling"]] = c(model[["building"]][["element"]][["ceiling"]], ceiling[["new_element"]])
    }
  }
  
  #Coating
  if ("coating" %in% names(l_type)){
    l_part = split(l_type[["coating"]], l_type[["coating"]][["part"]], drop = TRUE)
    coating = prepare_substitution(model, "coating", l_part)
    if (length(coating[["correspondence"]]) != 0){
      correspondence[["coating"]] = coating[["correspondence"]]
      model[["building"]][["element"]][["coating"]] = c(model[["building"]][["element"]][["coating"]], coating[["new_element"]])
    }
  }
  
  #Floor
  if ("floor" %in% names(l_type)){
    l_part = split(l_type[["floor"]], l_type[["floor"]][["part"]], drop = TRUE)
    floor = prepare_substitution(model, "floor", l_part)
    if (length(floor[["correspondence"]]) != 0){
      correspondence[["floor"]] = floor[["correspondence"]]
      model[["building"]][["element"]][["floor"]] = c(model[["building"]][["element"]][["floor"]], floor[["new_element"]])
    }
  }
  
  #Opening
  if ("opening" %in% names(l_type)){
    l_part = split(l_type[["opening"]][c("origin", "final")], l_type[["opening"]][["part"]], drop = TRUE)
    l_part = lapply(l_part, unique)
    opening = prepare_substitution(model, "opening", l_part)
    if (length(opening[["correspondence"]]) != 0){
      correspondence[["opening"]] = opening[["correspondence"]]
      model[["building"]][["element"]][["opening"]] = c(model[["building"]][["element"]][["opening"]], opening[["new_element"]])
    }
  }
  
  #Wall
  if ("wall" %in% names(l_type)){
    l_part = split(l_type[["wall"]], l_type[["wall"]][["part"]], drop = TRUE)
    wall = prepare_substitution(model, "wall", l_part)
    if (length(wall[["correspondence"]]) != 0){
      correspondence[["wall"]] = wall[["correspondence"]]
      model[["building"]][["element"]][["wall"]] = c(model[["building"]][["element"]][["wall"]], wall[["new_element"]])
    }
  }


# 2. check disposition in building and modify the type

  #Substitute type in building according to the list of measure
  model[["building"]][["building"]] = make_substitution_building(model[["building"]], correspondence, storey = selection[["storey"]],
     room = selection[["room"]], height = selection[["height"]] 
     )
  
  #For a selection by room, change the second part of the openings (window, door...)
  if (!is.null(selection[["room"]])){
    if (length(opening[["new_element"]]) != 0){
      model[["building"]][["building"]] = complete_substitution(model[["building"]], opening[["correspondence"]])
    }
  }
  
  #Update the tables with the substitute elements
  model = analyse_model(model, stage = "extract")
  
  
  #Suppress old and non-used elements
  name_element = lapply(model[["building"]][["element"]], names)
  #Ceiling
  if ("ceiling" %in% names(l_type)){
    ind_old = which(names(model[["building"]][["element"]][["ceiling"]]) %in% setdiff(name_element[["ceiling"]], model[["data_table"]][["room"]][["ceiling"]]))
    if (length(ind_old) != 0) model[["building"]][["element"]][["ceiling"]] = model[["building"]][["element"]][["ceiling"]][-ind_old]
  }
  #Coating
  if ("coating" %in% names(l_type)){
    ind_old = which(names(model[["building"]][["element"]][["coating"]]) %in% setdiff(name_element[["coating"]], model[["data_table"]][["coating"]][["type"]]))
    if (length(ind_old) != 0) model[["building"]][["element"]][["coating"]] = model[["building"]][["element"]][["coating"]][-ind_old]
  }
  #Floor
  if ("floor" %in% names(l_type)){
    ind_old = which(names(model[["building"]][["element"]][["floor"]]) %in% setdiff(name_element[["floor"]], model[["data_table"]][["room"]][["floor"]]))
    if (length(ind_old) != 0) model[["building"]][["element"]][["floor"]] = model[["building"]][["element"]][["floor"]][-ind_old]
  }
  #Opening
  if ("opening" %in% names(l_type)){
    ind_old = which(names(model[["building"]][["element"]][["opening"]]) %in% setdiff(name_element[["opening"]], model[["data_table"]][["opening"]][["type"]]))
    if (length(ind_old) != 0) model[["building"]][["element"]][["opening"]] = model[["building"]][["element"]][["opening"]][-ind_old]
  }
  #Wall
  if ("wall" %in% names(l_type)){
    ind_old = which(names(model[["building"]][["element"]][["wall"]]) %in% setdiff(name_element[["wall"]], model[["data_table"]][["wall"]][["type"]]))
    if (length(ind_old) != 0) model[["building"]][["element"]][["wall"]] = model[["building"]][["element"]][["wall"]][-ind_old]
  }
  
  return(model)
}
