#' Interpolate parameter to make a damaging function
#' 
#' @param parameter data.frame of parameters of relation between damaging, h, and d
#' @param h vector of hs
#' @param d vector of d
#' @param method the method chosen for the approximation
#' @param with_hazard logical
#' @return a data.frame with three columns h, d, damaging
#' 
#' @keywords internal

interpolate_damaging = function(parameter, h, d, method = "constant", with_hazard = TRUE) {
  analyse_raw_damaging_parameter = function(name) {
    # Analyzing parameters for array_hd
    n = length(grep("ys", name))
    if (length(unique(c(n, length(grep("yc", name)),  
        length(grep("zs", name)), length(grep("zc", name))))) != 1)
      stop("Check colnames !")
    
    list(y = paste(rep(c("ys", "yc"), n), rep(seq(n), each = 2), sep=""),
          z = paste(rep(c("zs", "zc"), n), rep(seq(n), each = 2), sep=""))
  }

  calc_value = function(x, parameter) {parameter[, 1] * x + parameter[, 2]}
		#	How parameters should be combined in array_hd
  
  make_matrix = function(x) {matrix(unlist(x), ncol = 2, byrow = TRUE)}
		# Constructing matrix for array_hd  
  
  fun = function(a, h, i, d) {
		# Technical function for a call in mapply
    x = calc_value(h, make_matrix(parameter[i, a[["y"]]]))
    y = calc_value(h, make_matrix(parameter[i, a[["z"]]]))
    if (length(x) == 0) return(rep(NA, length(d)))
    stats::approx(x, y, d, rule = 1:2, method = method)[["y"]]
  }
  
  a = analyse_raw_damaging_parameter(names(parameter))
  I = findInterval(h, parameter[, "x"])
  result = mapply(fun, h, I, MoreArgs = list(a = a, d = d))
  dimnames(result) = list(d = d, h = h)
  
  # reshape result
#  result = as.data.frame(matrix(data = result, nrow = prod(dim(result)), ncol = 1))
#  colnames(result) = unique(parameter[["curve"]])
#  if (with_hazard == TRUE) result = cbind(h = h, d = d, result)
  
  return(result)
}
