#' Create a list of useful (and expected) file names
#' 
#' @param check boolean, control the creation of file names related to some checkings 
#' @return a list of file names that floodam needs
#' 
#' @export

init_file_name = function(check = getOption("floodam_building_check"))
{
  file_name = list(
    building =  "building.xml",
    component = "component.csv",
    furniture = "furniture.csv", 
    category_model = "category_model.csv"
  )

  if (check) {
    file_name[["check"]] = "check.log"
    file_name[["BUILDING"]] = "BUILDING.txt"
  }

  return(file_name)
}

