#' Extract from a vector values that are in a certain range
#' 
#' @param x vector of values that will be checked
#' @param r range in which to check values of x
#' @param rule how boundaries should be treated for inclusion ("s" strict " e" or equal)
#' @return a vector with only the values that are in the range given by r
#' @examples
#' in_range(1:10, 2:4)
#' 
#' @export

in_range = function(x, r, rule = "se") {
	switch(rule,
		"ss" = x[x > min(r) & x < max(r)],
		"se" = x[x > min(r) & x <= max(r)],
		"es" = x[x >= min(r) & x < max(r)],
		"ee" = x[x >= min(r) & x <= max(r)],
		stop("Bad option for rule..."))
}
