#' Extract information at storey level
#' 
#' @param model_building a list that should represent a building version of model
#' @return a data.frame of informations extracted, ordered.
#' 
#' @keywords internal

extract_storey_03 = function(model_building) {		
	pattern = construct_data_frame_pattern(floodam.building::BUILDING[[model_building[["general"]][["version"]]]][["building"]][["storey"]])
	selection = grep("building", names(model_building), value = TRUE)
	
	result = simplify2data_frame(mapply(extract_something_from_building, model_building[selection], selection, 
		MoreArgs = list(pattern = pattern),
		SIMPLIFY = FALSE))

	result = result[order(result[["building"]], result[["storey"]]),]
}

extract_storey_02 = function(building, pattern, H_abs, height) {
		
	pattern = construct_data_frame_pattern(pattern)
	selection = grep("storey", names(building), value = TRUE)
	result = simplify2data_frame(mapply(extract_information, building[selection], selection, 
		MoreArgs = list(pattern = pattern, type_name = "storey"), SIMPLIFY = FALSE))
	
	# Adjusting H_abs
	if (is.null(H_abs)) H_abs = 0
	H = result[["H"]]
	H[is.na(H)] = 0
	result[["H_abs"]] = H_abs + H

	# Adjusting height
	if (!is.null(height)) {
		result[["height"]][is.na(result[["height"]])] = height - H[is.na(result[["height"]])]
	}

	return(result)
}
