#' Extract information from a wall
#' 
#' @param wall a list that should represent a wall
#' @param wall_name a character giving the wall name
#' @param pattern the pattern that will be used to extract information
#' @param what a character indicating what should be extracted
#' @return a data.frame of informations extracted
#' 
#' @keywords internal

extract_something_from_wall = function(wall, wall_name, pattern, what) {		
	pattern[["wall"]] = wall_name
	selection = grep(what, names(wall))

	simplify2data_frame(
		mapply(extract_information, wall[selection], 
		MoreArgs = list(pattern = pattern, type_name = "element", type = what), SIMPLIFY = FALSE))
}
