#' Extract information from a room
#' 
#' @param room a list that should represent a room.
#' @param room_name a character giving the room name.
#' @param pattern the pattern that will be used to extract information.
#' @param what a character indicating what should be extracted. default to "wall".
#' @return a data.frame of informations extracted.
#' 
#' @keywords internal

extract_something_from_room = function(room, room_name, pattern, what = "wall") {
	pattern[["room"]] = room_name

	selection = grep("wall", names(room), value = TRUE)
	if (what == "wall") {
		simplify2data_frame(
			mapply(extract_information, room[selection], selection, 
			MoreArgs = list(pattern = pattern, type_name = what),
			SIMPLIFY = FALSE))
	} else {
		simplify2data_frame(mapply(extract_something_from_wall, room[selection], selection, 
			MoreArgs = list(pattern = pattern, what = what),
			SIMPLIFY = FALSE))
	}
}
