#' Extract information at coating level
#' 
#' @param model_building a list that should represent a building version of model
#' @return a data.frame of informations extracted
#' 
#' @keywords internal

extract_coating_03 = function(model_building)
{
	pattern = construct_data_frame_pattern(floodam.building::BUILDING[[model_building[["general"]][["version"]]]][["building"]][["storey"]][["generic"]][["wall"]][["coating"]])
	selection = grep("building", names(model_building), value = TRUE)

	result = simplify2data_frame(
		mapply(
			extract_something_from_building,
			model_building[selection],
			selection, 
			MoreArgs = list(
				pattern = pattern,
				what = "coating"
			),
			SIMPLIFY = FALSE
		)
	)

	if (is.null(result)) {
		return(NULL)
	}

	result[order(result[["building"]], result[["storey"]], order_room(result[["room"]]), order_wall(result[["wall"]])),]
}

extract_coating_02 = function(building, pattern, parameter = NULL, file_log = NULL)
{
	pattern = construct_data_frame_pattern(pattern)
	selection = grep("storey", names(building), value = TRUE)

	result = simplify2data_frame(
		mapply(
			extract_something_from_storey,
			building[selection],
			selection, 
			MoreArgs = list(
				pattern = pattern,
				what = "coating"
			),
			SIMPLIFY = FALSE
		)
	)

	if (is.null(result)) {
		if (!is.null(file_log)) {
			report = "\n\t- No coating found."
			write(report, file = file_log, append = TRUE)
		}
		return(NULL)
	}
	if (!is.null(parameter)) {
		result = merge(result, parameter, all.x = TRUE, by = "type")
	}

	return(result)
}
