#' Transform a data.frame of damaging functions in a list of matrix of damaging functions
#' 
#' @param x array of damaging functions with columns "h" and "d"
#' @return a list of matrix
#' 
#' @keywords internal

damaging_as_matrix = function(x) {
	h = x[["h"]]
	d = x[["d"]]
	selection = !(names(x) == "h" | names(x) == "d")
	lapply(x[selection], matrix, nrow = length(unique(h)), ncol = length(unique(d)), 
		dimnames = list(h = unique(h), d = unique(d)))
}
