#' creat opening coordinates when missing.
#' 
#' @param coord coordinates of the wall
#' @param n number of openings present on this wall
#' @return data.frame of coordinates for n openings
#' 
#' @keywords internal

create_opening_coordinates = function(coord, n) {
	data.frame(
		x = seq(coord[["x"]], coord[["xx"]], length.out = n + 2)[-c(1, n + 2)],
		y = seq(coord[["y"]], coord[["yy"]], length.out = n + 2)[-c(1, n + 2)])
}
