#' Create default damaging functions
#' 
#' @param hazard_range list with two items ("f" and "d") giving hazard_range
#' @param component character, giving what type of component this is related to, if any
#' @param type, gives the resulting class of result
#' @param more, a list to add some dimensions to result.
#' @return an array representing a damaging function of class type, with default value (NA)
#' 
#' @keywords internal

create_default_damaging = function(hazard_range, component = NULL, type = "damaging", more = NULL) {
	
	if (is.null(more)) {
		result = array(as.numeric(NA),
			dim = c(length(hazard_range[[1]]), length(hazard_range[[2]])),
			dimnames = hazard_range)
	} else {
		result = array(as.numeric(NA),
			dim = c(length(hazard_range[[1]]), length(hazard_range[[2]]), sapply(more, length)),
			dimnames = c(hazard_range, more))
	}
	
	class(result) = type
	attr(result, "h_action") = NA
	attr(result, "dilapidation") = NA
	attr(result, "support") = NA
	attr(result, "component") = component

	invisible(result)
}
