#' Creates declination of model according to the declination file
#
#' @param model the selected model to decline
#' @param strategy_name the list of declination measures to apply
#' @param condition specify if some materials should be linked (NULL, "all", "wall")
#' @param select select only one sub_type of declination
#' @return a list with the new xmls and damaging
#' 
#' @keywords internal

create_combination_old = function(model, strategy_name, condition = NULL, select = NULL)
{

  #Load the list of material declinaisons
  #declinaison_name = list.files(file.path(model[["path"]][["adaptation"]], strategy_name), pattern = ".csv$")
  #declinaison = lapply(file.path(model[["path"]][["adaptation"]], strategy_name, declinaison_name), utils::read.csv2, stringsAsFactors = FALSE)
  #names(declinaison) = gsub(".csv$", "", declinaison_name)
  declinaison = utils::read.csv2(file.path(model[["path"]][["adaptation"]], strategy_name, "declinaison.csv"), stringsAsFactors = FALSE)

  #Select only some declination lines
  if (!is.null(select)){
    declinaison = declinaison[which(declinaison[["sub_type"]] == select),]
  }
  
  elem = split(declinaison, declinaison[c("type", "sub_type", "part")], drop = TRUE)
  mat_decli = lapply(elem, function(x) {x = x[["final"]]})
  combination = expand.grid(mat_decli)
  names(combination) = sub("./.", "_", names(combination), fixed = TRUE)
  
  # if ("dilapidation..value" %in% names(elem)){
  #     combination = expand.grid(wall_load_bearing_material = elem[["wall_load_bearing_material"]][["final"]],
  #           wall_load_bearing_render = elem[["wall_load_bearing_render"]][["final"]],
  #           wall_partition_material = elem[["wall_partition_material"]][["final"]],
  #           wall_lining_material = elem[["wall_lining_material"]][["final"]],
  #           wall_lining_insulating = elem[["wall_lining_insulating"]][["final"]],
  #           coating_material = elem[["coating__material"]][["final"]],
  #           ceiling_material = elem[["ceiling__material"]][["final"]],
  #           ceiling_insulating = elem[["ceiling__insulating"]][["final"]],
  #           ceiling_coating = elem[["ceiling__coating"]][["final"]],
  #           floor_material = elem[["floor__material"]][["final"]],
  #           floor_coating = elem[["floor__coating"]][["final"]],
  #           opening_door_garage_material = elem[["opening_door_garage_material"]][["final"]],
  #           opening_door_ext_material = elem[["opening_door_ext_material"]][["final"]],
  #           opening_window_material = elem[["opening_window_material"]][["final"]], 
  #           opening_window_shutter = elem[["opening_window_shutter"]][["final"]],
  #           dilapidation = elem[["dilapidation__value"]][["final"]])
  # } else {
  #   combination = expand.grid(wall_load_bearing_material = elem[["wall_load_bearing_material"]][["final"]],
  #           wall_load_bearing_render = elem[["wall_load_bearing_render"]][["final"]],
  #           wall_partition_material = elem[["wall_partition_material"]][["final"]],
  #           wall_lining_material = elem[["wall_lining_material"]][["final"]],
  #           wall_lining_insulating = elem[["wall_lining_insulating"]][["final"]],
  #           coating_material = elem[["coating__material"]][["final"]],
  #           ceiling_material = elem[["ceiling__material"]][["final"]],
  #           ceiling_insulating = elem[["ceiling__insulating"]][["final"]],
  #           ceiling_coating = elem[["ceiling__coating"]][["final"]],
  #           floor_material = elem[["floor__material"]][["final"]],
  #           floor_coating = elem[["floor__coating"]][["final"]],
  #           opening_door_garage_material = elem[["opening_door_garage_material"]][["final"]],
  #           opening_door_ext_material = elem[["opening_door_ext_material"]][["final"]],
  #           opening_window_material = elem[["opening_window_material"]][["final"]], 
  #           opening_window_shutter = elem[["opening_window_shutter"]][["final"]])
  # }

  if (!is.null(condition)){
    if (condition == "all"){
      #Partition and lining have the same material
      ind = which(combination[["wall_partition_material"]] == "placostil" & combination[["wall_lining_material"]] %in% c("dry", "masonry"))
      if (length(ind) > 0){combination = combination[-ind,]}
      ind = which(combination[["wall_partition_material"]] == "dry" & combination[["wall_lining_material"]] %in% c("placostil", "masonry"))
      if (length(ind) > 0){combination = combination[-ind,]}
      ind = which(combination[["wall_partition_material"]] == "masonry" & combination[["wall_lining_material"]] %in% c("dry", "placostil"))
      if (length(ind) > 0){combination = combination[-ind,]}

      #Same insulating for ceiling and wall
      ind = which(combination[["wall_lining_insulating"]] == "mineral" & combination[["ceiling_insulating"]] == "vegetal_fibre")
      if (length(ind) > 0){combination = combination[-ind,]}
      ind = which(combination[["wall_lining_insulating"]] == "vegetal" & combination[["ceiling_insulating"]] == "mineral_fibre")
      if (length(ind) > 0){combination = combination[-ind,]}

      #Door and window material are linked
      ind = union(which(combination[["opening_door_ext_material"]] == "exterior_PVC" & combination[["opening_window_material"]] %in% c("wood", "metal")),
            which(combination[["opening_door_garage_material"]] == "garage_overhead_PVC" & combination[["opening_window_material"]] %in% c("wood", "metal")))
      ind = union(ind, which(combination[["opening_window_shutter"]] == "louvered_PVC" & combination[["opening_window_material"]] %in% c("wood", "metal")))
      if (length(ind) > 0){combination = combination[-ind,]}
      ind = union(which(combination[["opening_door_ext_material"]] == "exterior_metal" & combination[["opening_window_material"]] %in% c("PVC", "wood")),
                 which(combination[["opening_door_garage_material"]] == "garage_overhead_metal" & combination[["opening_window_material"]] %in% c("wood", "PVC")))
      ind = union(ind, which(combination[["opening_window_shutter"]] == "rolling_aluminium" & combination[["opening_window_material"]] %in% c("wood", "PVC")))
      if (length(ind) > 0){combination = combination[-ind,]}
      ind = union(which(combination[["opening_door_ext_material"]] == "exterior_solid_wood" & combination[["opening_window_material"]] %in% c("PVC", "metal")),
            which(combination[["opening_door_garage_material"]] == "garage_overhead_wood" & combination[["opening_window_material"]] %in% c("PVC", "metal")))
      ind = union(ind, which(combination[["opening_window_shutter"]] == "louvered_wood" & combination[["opening_window_material"]] %in% c("PVC", "metal")))
      if (length(ind) > 0){combination = combination[-ind,]}
  
      ind = which(combination[["wall_lining_material"]] == "dry" & combination[["wall_partition_material"]] != "dry")
      if (length(ind) > 0){combination = combination[-ind,]}
      ind = which(combination[["wall_lining_material"]] == "masonry" & combination[["wall_partition_material"]] != "masonry")
      if (length(ind) > 0){combination = combination[-ind,]}
      ind = which(combination[["wall_lining_material"]] == "other" & combination[["wall_partition_material"]] %in% c("masonry","dry"))
      if (length(ind) > 0){combination = combination[-ind,]}
    }
  }

  rownames(combination) = paste("V", sep ="_", seq(nrow(combination)))

  #Create a file with the name of the strategy
  model[["path"]][["declinaison_output"]] = file.path(model[["path"]][["model_output_damaging"]], sprintf("%s", strategy_name))
  #model[["path"]][["declinaison_output"]] = file.path(getwd(), sprintf("%s", strategy_name))
  if (!file.exists(model[["path"]][["declinaison_output"]])) {
    dir.create(path = model[["path"]][["declinaison_output"]])
  }
  
  #Save combination table
  utils::write.csv2(combination, file.path(model[["path"]][["declinaison_output"]], "combination_table.csv"))

  return(combination)
}






